//***********************************************************************
//Copyright © 2009-2013 Corporation for National Research Initiatives
//("CNRI"). This software is made available under the terms of the
//CNRI License Agreement  that is located at hdl:1895.26/1012
//or http://hdl.handle.net/1895.26/1012.
//***********************************************************************
//Developer: Kevin Hosford
//Developer: Robert R Tupelo-Schneck <schneck@cnri.reston.va.us>
//***********************************************************************
const NAME = "HDL and DOI Link Finder";
const CONTRACTID = "@cnri.net/handle-link-finder;1";
const CID = Components.ID("e6cb79c0-fb00-11de-8a39-0800200c9a66");

const Cc = Components.classes;
const Ci = Components.interfaces;

function dump(msg) {
    Cc["@mozilla.org/consoleservice;1"]
        .getService(Ci.nsIConsoleService)
            .logStringMessage(msg);
}

var prefService = null;

var handleLinkFinder = {
    initialized: false,
    
    init: function() {
        if(handleLinkFinder.initialized) return;
        if(prefService==null) {
            prefService = Cc["@mozilla.org/preferences-service;1"].getService(Ci.nsIPrefService);
            prefService = prefService.getBranch("extensions.cnri-handle.").QueryInterface(Ci.nsIPrefBranch2);
            prefService.addObserver("findLinks", handleLinkFinder, false);
            handleLinkFinder.observe(null,null,null);
        }
    },

    observe: function(subject, topic, data) {
        // dump("findLinksObserve");
        handleLinkFinder.findLinks = getBoolPref("findLinks",true);
    },
        
    findLinks: true,
    
    hdlRe: /\b(?:hdl|doi):\s*\S*\/\S*[^\s.?!)\]'",:;]\b/i,

    makeLinks: function(theDocument) {
        var nodesWithHdls = new Array();
        handleLinkFinder.getNodesWithHdls(theDocument.documentElement, nodesWithHdls);
        
        var len = nodesWithHdls.length;
        for (var i = 0; i < len; i++) {
            var nodes = new Array(nodesWithHdls[i]);
            while (nodes.length > 0) {
                var node = nodes.shift();
                var hdlMatches = node.nodeValue.match(handleLinkFinder.hdlRe);
                if (hdlMatches == null || hdlMatches.length == 0) continue;
                var firstMatch = hdlMatches[0];
                var pos = node.nodeValue.indexOf(firstMatch);
                
                if (pos == -1) continue;
                else if (pos == 0) {
                    if (node.nodeValue.length > firstMatch.length) {
                        node.splitText(firstMatch.length);
                        nodes.push(node.nextSibling);
                    }
                    
                    var theLink = theDocument.createElement("a");
                    theLink.href = node.nodeValue;
                    node.parentNode.insertBefore(theLink, node);
                    theLink.appendChild(node);
                }
                else {
                    node.splitText(pos);
                    nodes.unshift(node.nextSibling);
                }
            }
        }
    },
    
    getNodesWithHdls: function(node, nodesWithHdls) {
        if (node.nodeType == 3) {
            if (node.nodeValue.search(handleLinkFinder.hdlRe) != -1) {
                nodesWithHdls.push(node);
            }
        }
        else if (node && node.nodeType == 1 && node.hasChildNodes() && !node.tagName.match(/^(a|head|object|embed|script|style|frameset|frame|iframe|textarea|input|button|select|option)$/i)) {
            var nextNode = node.firstChild;
            while(nextNode) {
                handleLinkFinder.getNodesWithHdls(nextNode,nodesWithHdls);
                nextNode = nextNode.nextSibling;
            }
        }
    },
    
    QueryInterface: function(iid) {
        if (!iid.equals(Components.interfaces.nsISupports)) {
            throw Components.results.NS_ERROR_NO_INTERFACE;
        }
        return handleLinkFinder;
    }
};

handleLinkFinder.wrappedJSObject = handleLinkFinder;

var HdlLinkFinderFactory = new Object();

HdlLinkFinderFactory.createInstance = function (outer, iid) {
    if (outer != null) {
        throw Components.results.NS_ERROR_NO_AGGREGATION;
    }
    handleLinkFinder.init();
    return handleLinkFinder.QueryInterface(iid);
}

var HdlLinkFinderModule = new Object();

HdlLinkFinderModule.registerSelf = function (compMgr, fileSpec, location, type)
{
    compMgr.QueryInterface(Ci.nsIComponentRegistrar)
        .registerFactoryLocation(CID, NAME, CONTRACTID, fileSpec, location, type);
}

HdlLinkFinderModule.unregisterSelf = function(compMgr, location, loaderStr) {
    compMgr = compMgr.QueryInterface(Ci.nsIComponentRegistrar);
    compMgr.unregisterFactoryLocation(CID, location);
}

HdlLinkFinderModule.getClassObject = function (compMgr, cid, iid)
{
  if (!cid.equals(CID))
    throw Components.results.NS_ERROR_NO_INTERFACE;

  if (!iid.equals(Ci.nsIFactory))
    throw Components.results.NS_ERROR_NOT_IMPLEMENTED;

  return HdlLinkFinderFactory;
}

var getBoolPref = function(pref,def) {
    try {
        if (prefService) {
            if(prefService.prefHasUserValue(pref)) {
                return prefService.getBoolPref(pref);
            }
            else return def;
        }
    }
    catch(e) {
        return def;
    }
}

function NSGetModule(compMgr, fileSpec) {
    return HdlLinkFinderModule;
}

function NSGetFactory(cid) {
    return HdlLinkFinderFactory;
}
